#ifndef _CCOMPRESS_
#define _CCOMPRESS_

//#define TESTCCOMPRESS
#define CHARACTER_ARRAY_OFFSET   (512)

#ifdef TESTCCOMPRESS
#include <stdlib.h>
#include <stdio.h>
#endif

#include <string.h>
//#include <assert.h>
#include <stdio.h>
#include "TSpell.h"
#include "Uio.h"

#define ENDOFSEQUENCELENGTH  (2)
#define MAXWORDLENGTH        (40)

#ifndef OK
#define OK                   (1)
#endif

#ifndef ERROR
#define ERROR                (0)
#endif
//extern short GetWord(byte *word, byte *buff, short *offset);
//extern short PrefixCompress(byte *buff, short *offset, byte *LastWord, byte *CurrWord);
//extern short CompressedWordLength(byte *LastWord, byte *CurrWord);
//extern void PutEndOfSequence(byte *buff, short *offset);
//extern void ResetReader(byte *buff, short *offset);
//#endif


#include <stdlib.h>

#define MAXLINELENGTH        (300)



typedef struct {
		long Count;
		char Character;
	       }CountStruct;

typedef struct {
		char Offset;
		char Shift;
	       }MapStruct;



class CCompress {

public:
	// Routines used to compress and decompress a word
	short  GetWord(UInt8 *Word, UInt8 *buff, short *offset);
	void PutWord(UInt8 *buff, short *offset, UInt8 *Word, short length, UInt8 redundant);
	short  PrefixCompress(UInt8 *buff, short *offset, UInt8 *LastWord, UInt8 *CurrWord);
	short  CompressedWordLength(UInt8 *LastWord, UInt8 *CurrWord);
	void PutEndOfSequence(UInt8 *buff, short *offset);
	void ResetReader(UInt8 *buff, short *offset);

	// Routines used to generate and handle the compression tables
	//long CountCharacters(Uio *Infile);
	//long CountCharacters(FILE *Infile);
	//void MakeMapArray();
	//void MakeCharacterArray();
	long  SaveCharacterArray(Uio *OutFile,long Offset);
	long  SaveCharacterArray(FILE *OutFile,long Offset);
	long  LoadCharacterArray(Uio *Infile, long Offset);
	//long  LoadCharacterMap(Uio *Infile, long Offset);

	CCompress();
	~CCompress();

#ifndef TESTCCOMPRESS
private:
#endif
	short  GetValue(UInt8 *buff, short *offset);
	void PutValue(UInt8 *buff, short *offset, UInt8 ch);
	short  GetChar(UInt8 *buff, short *offset);
	void PutChar(UInt8 *buff, short *offset, UInt8 ch);
	short  GetRedundant(UInt8 *buff, short *offset);
	void PutRedundant(UInt8 *buff, short *offset, UInt8 redundant);
	void PutEOW(UInt8 *buff, short *offset);
	short  Same(UInt8 *Word1, UInt8 *Word2);
	
	//void SortByCount();
	#ifdef TESTCCOMPRESS
	void PrintCountArray();
	void PrintMapArray();
	#endif
	
	char        CharacterArray[18][14];
	MapStruct   CharacterMap[256]; // could be tuned to only allocate
			      // this memory if it is needed.
	UInt8        WordBuffer[MAXWORDLENGTH];
	CountStruct *CountArray;
};

#endif